// This program must be compiled on a Japanese system.

import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.net.*;
import java.applet.*;
import java.util.*;

final public class Inflection extends Applet implements Runnable, ActionListener, ItemListener, AdjustmentListener
{  boolean _fInit = false, _fError = false;
   Thread _thread = null;
   FontMetrics _fm;
   String _astrPhonemes[], _astrRoman[];
   Panel _panel;
   Scrollbar _scrollbar;
   Choice _choiceFont;
   TextField _tf;
   Hashtable _hashImg;

   boolean _fNegative = false, _fPast = false, _fPolite = false, _fColloq = false;

   int _iImgSize = 0;
   int _cxString1, _cxString2, _iAscent, _iDescent;
   int _iScroll = 0;

   static Hashtable _hashKana, _hashPhon, _hashRoman, _hashRomanToPhon;
   static int _cKana = makeHash();

   final static String _strWait = "Now loading images...";
   final static String _strError = "Image load error!";
   final static String _astrFonts[] =
   {  "Gothic", "Kaisho", "MaruGothic", "Mincho", "Pop", "Textbook"
   };

   String _strFont = "Textbook";
   boolean _fKata = false;

   final static int GROUP_I = 1, GROUP_II = 2, KURU = 3, SURU = 4,
                    COPULA = 5, ADJECTIVE = 6, MASU = 7, MASEN = 8;
   String _strRoot = "hanas", _strReading = "";
   int _iGroup = GROUP_I;

   final String _astrVerbs[] =
   {  "Group I: hanasu (speak)", "Group I: kiku (listen to)", "Group I: oyogu (swim)",
      "Group I: tatu (stand up)", "Group I: uru (sell)", "Group I: arau (wash)",
      "Group I: sinu (die)", "Group I: tobu (fly)", "Group I: yomu (read)",
      "Group I: aru (exist)", "Group I: iku (go)",
      "Group II: miru (watch)", "Group II: otiru (fall)",
      "Group II: neru (sleep)", "Group II: taberu (eat)",
      "Kuru: kuru (come)", "Suru: suru (do)",
      "Copula: da (be)",
      "Adjective: yoi (good)", "Adjective: atui (hot)",
      "Adjective: uresii (glad)", "Adjective: oisii (tasty)",
      "Adjective: nai (not exist)"
   };

   final String _strOK = "OK",
                _strNegative = "Negative", _strPast = "Past",
                _strPolite = "Polite", _strColloq = "Colloquial";

   final static String _strKana = "ĂƂÂłǂȂɂʂ˂̂͂Ђӂւق΂тԂׂڂς҂Ղ؂ۂ܂݂ނ߂";

   final static String _strHashKana = ",a,,i,,u,,e,,o,,ka,,ki,,ku,,ke,,ko,,ga,,gi,,gu,,ge,,go,,sa,,si,,su,,se,,so,,za,,zi,,zu,,ze,,zo,,ta,,ti,,tu,,te,,to,,da,,di,,du,,de,,do,,na,,ni,,nu,,ne,,no,,ha,,hi,,hu,,he,,ho,,ba,,bi,,bu,,be,,bo,,pa,,pi,,pu,,pe,,po,,ma,,mi,,mu,,me,,mo,,ya,,yu,,yo,,ra,,ri,,ru,,re,,ro,,wa,,wi,,we,,wo,,N,,Q,,kya,,kyu,,kyo,,gya,,gyu,,gyo,,sya,,syu,,syo,,zya,,zyu,,zyo,,tya,,tyu,,tyo,,dya,,dyu,,dyo,ɂ,nya,ɂ,nyu,ɂ,nyo,Ђ,hya,Ђ,hyu,Ђ,hyo,т,bya,т,byu,т,byo,҂,pya,҂,pyu,҂,pyo,݂,mya,݂,myu,݂,myo,,rya,,ryu,,ryo";

   final static String _strhashRoman = "sya,sha,si,shi,syu,shu,syo,sho,zya,ja,zi,ji,zyu,ju,zyo,jo,tya,cha,ti,chi,tyu,chu,tyo,cho,tu,tsu,dya,ja,dyu,ju,dyo,jo,di,ji,du,zu,hu,fu,N,n";

   final private static int makeHash()
   {  _hashPhon = new Hashtable();
      _hashKana = new Hashtable();
      int cKana = 0;

      StringTokenizer st = new StringTokenizer(_strHashKana, ",");
      while (st.hasMoreTokens())
      {  String strKana = st.nextToken(), strPhon = st.nextToken();
	 _hashPhon.put(strPhon, strKana);
	 _hashKana.put(strKana, strPhon);
	 cKana++;
      }

      _hashRoman = new Hashtable();
      _hashRomanToPhon = new Hashtable();
      st = new StringTokenizer(_strhashRoman, ",");
      while (st.hasMoreTokens())
      {  String strPhon = st.nextToken(), strRoman = st.nextToken();
	 _hashRoman.put(strPhon, strRoman);

	 if (!strRoman.equals("n")
	     && !_hashRomanToPhon.containsKey(strRoman))
	 {  _hashRomanToPhon.put(strRoman, strPhon);
	 }
      }

      return cKana;
   }

   final private void addCheckbox(String str, Panel panel)
   {  Checkbox cb = new Checkbox(str);
      panel.add(cb);
      cb.addItemListener(this);
   }

   final public void init()
   {  setForm();

      Color color = new Color(0xf0, 0xf0, 0xf0);
      setBackground(color);

      Panel panel = _panel = new Panel();
      panel.setBackground(color);
      panel.setLayout(new GridLayout(2, 4));

      Choice choice = new Choice();
      for (int iIndex = 0; iIndex < _astrFonts.length; iIndex++)
      {  choice.addItem(_astrFonts[iIndex] + ", Hiragana");
	 choice.addItem(_astrFonts[iIndex] + ", Katakana");
      }

      choice.select(_strFont + ", Hiragana");
      choice.addItemListener(this);
      panel.add(_choiceFont = choice);

      choice = new Choice();
      for (int iIndex = 0; iIndex < _astrVerbs.length; iIndex++)
      {  choice.addItem(_astrVerbs[iIndex]);
      }

      panel.add(choice);
      choice.addItemListener(this);

      panel.add(_tf = new TextField());

      Button button = new Button(_strOK);
      panel.add(button);
      button.addActionListener(this);

      addCheckbox(_strNegative, panel);
      addCheckbox(_strPast, panel);
      addCheckbox(_strPolite, panel);
      addCheckbox(_strColloq, panel);
      add(panel);
      add(_scrollbar = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, 0));
      _scrollbar.addAdjustmentListener(this);

      Font fontNew = new Font("serif", Font.BOLD, 32),
           fontOld = getFont();
      setFont(fontNew);
      panel.setFont(fontOld);
      FontMetrics fm = _fm = getFontMetrics(fontNew);
      _cxString1 = fm.stringWidth(_strWait);
      _cxString2 = fm.stringWidth(_strError);
      _iAscent = fm.getMaxAscent();
      _iDescent = fm.getMaxDescent();

      if (!_fInit && !_fError && _thread == null)
      {  (_thread = new Thread(this)).start();
      }
   }

   final public void start()
   {  requestFocus();
   }

   final private void setScrollbar()
   {  int iCharacters = _strReading.length() * _iImgSize,
	  iScrollbarWidth = _scrollbar.getSize().width;
      int iVisible = Math.min(iCharacters, iScrollbarWidth);
      int iOffset = Math.min(iCharacters - iVisible, _iScroll);
      _scrollbar.setValues(iOffset, iScrollbarWidth, 0, iCharacters);
      _scrollbar.setBlockIncrement(iVisible);
      _iScroll = iOffset;
   }

   final public synchronized void doLayout()
   {  if (_panel != null)
      {  Dimension dim = getSize();
	 int iWidth = dim.width, iHeight = dim.height;
	 _panel.setBounds(0, 0, iWidth,
			  Math.min(iHeight * 3 / 8, _panel.getPreferredSize().height));

	 if (_scrollbar != null)
	 {  int iScrollbarHeight = _scrollbar.getPreferredSize().height;
	    _scrollbar.setBounds(0, iHeight - iScrollbarHeight,
				 iWidth, iScrollbarHeight);
	    setScrollbar();
	 }
      }
   }

   final public void run()
   {  try
      {  Image image = getImage(getCodeBase(),
				_strFont.toLowerCase() + (_fKata ? "_k.gif" : ".gif"));
	 MediaTracker media = new MediaTracker(this);
	 media.addImage(image, 0);
	 media.waitForAll();

	 if (media.isErrorAny())
	 {  _fError = true;
	 }
	 else
	 {  int cImages = _strKana.length(),
	        iImgSize = _iImgSize = image.getHeight(this);
	    ImageProducer imgprod = image.getSource();
	    _hashImg = new Hashtable();

	    for (int iIndex = 0; iIndex < cImages; iIndex++)
	    {  _hashImg.put(new Character(_strKana.charAt(iIndex)),
			    createImage(new FilteredImageSource
					(imgprod,
					 new CropImageFilter(iIndex * iImgSize, 0,
							     iImgSize, iImgSize))));
	    }

	    _scrollbar.setUnitIncrement(iImgSize);
	    _fInit = true;
	 }
      }
      catch (Exception e)
      {  _fError = true;
      }

      _thread = null;
      repaint();
   }

   final public void paint(Graphics g)
   {  Dimension dim = getSize();
      int yOffset = dim.height * 3 / 8;
      int cx = dim.width, cy = dim.height - yOffset - _scrollbar.getSize().height;
      int iAscent = _iAscent, iDescent = _iDescent;
      int yString = (cy + iAscent - iDescent) / 2 + yOffset;

      if (_fError)
      {  g.drawString(_strError, (cx - _cxString2) / 2, yString);
      }
      else if (_fInit)
      {  int x = -_iScroll;

	 int yRoman = cy - iDescent + yOffset,
	     yPhoneme = yRoman - iAscent - iDescent,
	     yImage = yPhoneme - iAscent - _iImgSize;
	 int cChars = _strReading.length();

	 drawStrings(g, _astrPhonemes, x, yPhoneme);
	 drawStrings(g, _astrRoman, x, yRoman);

	 for (int iIndex = 0; iIndex < cChars; iIndex++)
	 {  g.drawImage((Image)_hashImg.get(new Character(_strReading.charAt(iIndex))),
			x, yImage, this);
	    x += _iImgSize;
	 }
      }
      else
      {  g.drawString(_strWait, (cx - _cxString1) / 2, yString);
      }
   }

   final private void drawStrings(Graphics g, String astr[], int x, int y)
   {  if (astr == null)
      {  return;
      }

      int iNextDraw = 0;
      for (int iIndex = 0; iIndex < astr.length; iIndex++)
      {  String str = astr[iIndex];
	 if (str != null)
	 {  g.drawString(str,
			 x + (_iImgSize * (iNextDraw + iIndex + 1) - _fm.stringWidth(str)) / 2,
			 y);
	    iNextDraw = iIndex + 1;
	 }
      }
   }

   final private static String kanaToPhoneme(String strKana)
   {  int iLast;
      if ((iLast = strKana.length() - 1) < 0)
      {  return "";
      }

      int iIndex = 0;
      StringBuffer sbAlpha = new StringBuffer();
      String strPhon;

      while (iIndex <= iLast)
      {  if (iIndex < iLast
	     && (strPhon = (String)_hashKana.get(strKana.substring(iIndex, iIndex + 2))) != null)
	 {  iIndex += 2;
	 }
	 else
	 {  strPhon = (String)_hashKana.get(strKana.substring(iIndex, iIndex + 1));
	    iIndex++;
	 }

	 sbAlpha.append(strPhon);
      }

      return sbAlpha.toString();
   }

   final private static String phonemeToKana(String strPhon)
   {  StringBuffer sbHiragana = new StringBuffer();
      String strKey = "", strKana;
      int cLength = strPhon.length();

      while (cLength-- > 0)
      {  strKey += strPhon.charAt(0);
	 strPhon = strPhon.substring(1);

	 if (_hashRomanToPhon.containsKey(strKey))
	 {  strKey = (String)_hashRomanToPhon.get(strKey);
	 }

	 if ((strKana = (String)_hashPhon.get(strKey)) != null)
	 {  sbHiragana.append(strKana);
	    strKey = "";
	 }
	 else if (strKey.length() >= 2)
	 {  char c0 = strKey.charAt(0), c1 = strKey.charAt(1);
	    if ((c0 == 'n' && c1 != 'y')
		|| (c0 == 'm' && (c1 == 'm' || c1 == 'b' || c1 == 'p')))
	    {  sbHiragana.append('');
	       strKey = ((c0 == 'n' && (c1 == '\'' || c1 == '-'))
			 ? "" : strKey.substring(1));
	    }
	    else if (c0 == c1 || strKey.equals("tch"))
	    {  sbHiragana.append('');
	       strKey = strKey.substring(1);
	    }
	 }
      }

      if (strKey.equals("n"))
      {  sbHiragana.append('');
      }
      else if (strKey.length() != 0)
      {  return null;
      }

      return sbHiragana.toString();
   }

   final private static String[] getPhoneme(String strKana)
   {  int cKana = strKana.length();
      if (cKana == 0)
      {  return null;
      }

      String astr[] = new String[cKana];

      for (int iIndex = 0; iIndex < cKana; iIndex++)
      {  if ((astr[iIndex] = (String)_hashKana.get(strKana.substring(iIndex, iIndex + 1)))
	     == null)
	 {  astr[iIndex - 1] = null;
	    astr[iIndex] = (String)_hashKana.get(strKana.substring(iIndex - 1, iIndex + 1));
	 }
      }

      return astr;
   }

   final private static String[] romanize(String[] astrPhonemes)
   {  if (astrPhonemes == null)
      {  return null;
      }

      int cLength = astrPhonemes.length;
      String astrRoman[] = new String[cLength];
      for (int iIndex = 0; iIndex < cLength; iIndex++)
      {  String str = astrPhonemes[iIndex];
	 Object obj;
	 astrRoman[iIndex] = (str == null || (obj = _hashRoman.get(str)) == null
			      ? str
			      : (String)obj);
      }

      for (int iIndex = 0; iIndex < cLength - 1; iIndex++)
      {  // do not process the last character;

	 String str = astrRoman[iIndex];
	 if (str != null)
	 {  if (str.equals("u") || str.equals("o") || str.equals("i"))
	    {  String strPrev;
	       if (iIndex > 0
		   && (strPrev = astrRoman[iIndex - 1]) != null
		   && (strPrev.endsWith(str)
		       || (strPrev.endsWith("o") && !str.equals("i"))))
	       {  StringBuffer sb = new StringBuffer(strPrev);
		  int cLast = sb.length() - 1;
		  char c = sb.charAt(cLast);
		  sb.setCharAt(cLast, (c == 'o' ? '\u00f4'
				       : (c == 'u' ? '\u00fb' : '\u00ee')));
		  astrRoman[iIndex - 1] = null;
		  astrRoman[iIndex] = sb.toString();
	       }
	    }
	    else if (str.equals("n") || str.equals("Q"))
	    {  int iIndexNext = iIndex + 1;
	       while (iIndexNext < cLength)
	       {  String strNext = astrRoman[iIndexNext++];
		  if (strNext == null)
		  {  continue;
		  }

		  char c = strNext.charAt(0);
		  if (str.equals("n"))
		  {  if (c == 'm' || c == 'p' || c == 'b')
		     {  astrRoman[iIndex] = "m";
		     }
		     else if (c == 'a' || c == 'i' || c == 'u'
			      || c == 'e' || c == 'o' || c == 'y')
		     {  astrRoman[iIndex] = "n'";
		     }
		  }
		  else
		  {  astrRoman[iIndex] = String.valueOf(c == 'c' ? 't' : c);
		  }

		  break;
	       }
	    }
	 }
      }

      return astrRoman;
   }

   final private boolean setForm()
   {  String strRoot = _strRoot;
      int iGroup = _iGroup;
      boolean fNegative = _fNegative;

      if (iGroup == ADJECTIVE && strRoot.equals("na")) // the adjective nai
      {  fNegative = !fNegative;
	 strRoot = "ar";
	 iGroup = GROUP_I;
      }

      StringBuffer sb = new StringBuffer(strRoot);

      if (_fPolite
	  && !(fNegative && _fColloq) // !desu
	  && !(iGroup == ADJECTIVE && !fNegative)) // !desu
      {  switch (iGroup)
	 {  case GROUP_I:
	       int iChars = sb.length();
	       if (sb.charAt(iChars - 1) == 'w')
	       {  sb.setLength(iChars - 1);
	       }
	    case KURU:
	    case SURU:
	       sb.append("imas");
	       break;
	    case GROUP_II:
	       sb.append("mas");
	       break;
	    case COPULA:
	       sb.append(fNegative ? "dearimas" : "des");
	       break;
	    case ADJECTIVE:
	       sb.append("kuarimas");
	       break;
	 }

	 iGroup = MASU;
      }

      if (fNegative)
      {  if (iGroup == MASU)
	 {  sb.append("eN");
	    iGroup = MASEN;
	 }
	 else
	 {  switch (iGroup)
	    {  case GROUP_I:
		  if (strRoot.equals("ar")) // the verb aru
		  {  sb.setLength(0);
		  }
		  else
		  {  sb.append('a');
		  }
		  break;
	       case KURU:
		  sb.append('o');
		  break;
	       case SURU:
		  sb.append('i');
		  break;
	       case COPULA:
		  sb.append("de");
		  break;
	       case ADJECTIVE:
		  sb.append("ku");
		  break;
	    }

	    sb.append("na");
	    iGroup = ADJECTIVE;
	 }
      }

      switch (iGroup)
      {  case GROUP_I:
	 {  int iChars = sb.length();
	    char cLastChar = sb.charAt(iChars - 1);

	    if (_fPast)
	    {  sb.setLength(iChars - 1);

	       switch (cLastChar)
	       {  case 'k':
		     sb.append(iChars == 2 && sb.charAt(0) == 'i' ? "Qta" : "ita");
		     break;
		  case 'g':
		     sb.append("ida");
		     break;
		  case 't':
		  case 'r':
		  case 'w':
		     sb.append("Qta");
		     break;
		  case 'n':
		  case 'b':
		  case 'm':
		     sb.append("Nda");
		     break;
		  default:
		     sb.append(cLastChar).append("ita");
		     break;
	       }
	    }
	    else
	    {  if (cLastChar == 'w')
	       {  sb.setLength(iChars - 1);
	       }

	       sb.append('u');
	    }

	    break;
	 }
	 case GROUP_II:
	    sb.append(_fPast ? "ta" : "ru");
	    break;
	 case KURU:
	 case SURU:
	    sb.append(_fPast ? "ita" : "uru");
	    break;
	 case COPULA:
	    sb.append(_fPast ? "daQta" : "da");
	    break;
	 case ADJECTIVE:
	    sb.append(_fPast ? "kaQta" : "i");
	    break;
	 case MASU:
	    sb.append(_fPast ? "ita" : "u");
	    break;
	 case MASEN:
	    if (_fPast)
	    {  sb.append("desita");
	    }
	    break;
      }

      if (_fPolite && iGroup == ADJECTIVE)
      {  sb.append("desu");
      }

      String str;
      if ((str = phonemeToKana(sb.toString())) != null)
      {  _strReading = str;
	 _astrPhonemes = getPhoneme(str);
	 _astrRoman = romanize(_astrPhonemes);
	 return true;
      }

      return false;
   }

   final private boolean setPredicate(String str)
   {  int iIndex, iGroup = 0;
      String strGroup = null;
      str = str.trim();

      if ((iIndex = str.indexOf(':')) >= 0)
      {  strGroup = str.substring(0, iIndex).trim().toUpperCase();
	 str = str.substring(iIndex + 1);
	 str = ((iIndex = str.indexOf('(')) >= 0 ? str.substring(0, iIndex) : str).trim();
      }

      if ((str = phonemeToKana(str)) == null
	  || (str = kanaToPhoneme(str)) == null)
      {  return false;
      }

      int iChars = str.length();

      if (strGroup != null)
      {  if (strGroup.equals("GROUP I"))
	 {  iGroup = GROUP_I;
	 }
	 else if (strGroup.equals("GROUP II"))
	 {  iGroup = GROUP_II;
	 }
	 else if (strGroup.equals("KURU"))
	 {  iGroup = KURU;
	 }
	 else if (strGroup.equals("SURU"))
	 {  iGroup = SURU;
	 }
	 else if (strGroup.equals("COPULA"))
	 {  iGroup = COPULA;
	 }
	 else if (strGroup.equals("ADJECTIVE"))
	 {  iGroup = ADJECTIVE;
	 }
      }
      else
      {  if (iChars >= 2)
	 {  char c;
	    if ((c = str.charAt(iChars - 1)) == 'i')
	    {  if ((c = str.charAt(iChars - 2)) == 'a'
		   || c == 'i' || c == 'u' || c == 'o')
	       {  iGroup = ADJECTIVE;
	       }
	    }
	    else if (c == 'u')
	    {  if (str.endsWith("iru") || str.endsWith("eru"))
	       {  iGroup = GROUP_II;
	       }
	       else if (str.endsWith("suru"))
	       {  iGroup = SURU;
	       }
	       else if (str.equals("kuru"))
	       {  iGroup = KURU;
	       }
	       else
	       {  iGroup = GROUP_I;
	       }
	    }
	    else if (str.endsWith("da"))
	    {  iGroup = COPULA;
	    }
	 }
      }

      switch (iGroup)
      {  case GROUP_I:
	 {  if (iChars <= 1
		|| str.charAt(iChars - 1) != 'u')
	    {  return false;
	    }

	    str = str.substring(0, iChars - 1);
	    switch (str.charAt(iChars - 2))
	    {  case 'a':
	       case 'i':
	       case 'u':
	       case 'e':
	       case 'o':
		  str += 'w';
		  break;
	    }

	    break;
	 }
	 case GROUP_II:
	 {  if (iChars <= 2
		|| !(str.endsWith("iru") || str.endsWith("eru")))
	    {  return false;
	    }

	    str = str.substring(0, iChars - 2);
	    break;
	 }
	 case KURU:
	 {  if (!str.endsWith("kuru"))
	    {  return false;
	    }

	    str = str.substring(0, iChars - 3);
	    break;
	 }
	 case SURU:
	 {  if (!str.endsWith("suru"))
	    {  return false;
	    }

	    str = str.substring(0, iChars - 3);
	    break;
	 }
	 case COPULA:
	 {  if (!str.endsWith("da"))
	    {  return false;
	    }

	    str = str.substring(0, iChars - 2);
	    break;
	 }
	 case ADJECTIVE:
	 {  char c;
	    if (iChars <= 1
		|| str.charAt(iChars - 1) != 'i'
		|| !((c = str.charAt(iChars - 2)) == 'a'
		     || c == 'i' || c == 'u' || c == 'o'))
	    {  return false;
	    }

	    str = str.substring(0, iChars - 1);
	    break;
	 }
	 default:
	    return false;
      }

      _strRoot = str;
      _iGroup = iGroup;
      return setForm();
   }

   final public void adjustmentValueChanged(AdjustmentEvent ae)
   {  _iScroll = _scrollbar.getValue();
      repaint();
   }

   final public void actionPerformed(ActionEvent ae)
   {  if (ae.getActionCommand().equals(_strOK))
      {  if (_fInit && setPredicate(_tf.getText()))
	 {  setScrollbar();
	    repaint();
	 }
      }
   }

   final public void itemStateChanged(ItemEvent ie)
   {  ItemSelectable iselect = ie.getItemSelectable();
      Object obj = ie.getItem();

      if (iselect instanceof Choice)
      {  String str = (String)obj;

	 if (iselect == _choiceFont)
	 {  int iIndex = str.indexOf(',');
	    String strFont = str.substring(0, iIndex);
	    boolean fKata = (str.charAt(iIndex + 2) == 'K');

	    if (fKata != _fKata
		|| !strFont.equals(_strFont))
	    {  _strFont = strFont;
	       _fKata = fKata;

	       if (_thread != null)
	       {  _thread.stop();
	       }

	       _fInit = _fError = false;
	       (_thread = new Thread(this)).start();
	       repaint();
	    }
	 }
	 else if (setPredicate(str))
	 {  setScrollbar();
	    repaint();
	 }
      }
      else if (iselect instanceof Checkbox)
      {  boolean fState = ((Checkbox)iselect).getState();

	 if (obj.equals(_strPast))
	 {  _fPast = fState;
	 }
	 else if (obj.equals(_strNegative))
	 {  _fNegative = fState;
	 }
	 else if (obj.equals(_strPolite))
	 {  _fPolite = fState;
	 }
	 else if (obj.equals(_strColloq))
	 {  _fColloq = fState;
	 }

	 if (setForm())
	 {  setScrollbar();
	    repaint();
	 }
      }
   }
}
